import { IActionParam, IParam } from "@ibiz-core";
import { Subject } from "rxjs";

/**
 * 部件基类状态
 */
 export interface ControlStateBase {
  /**
   * 部件名称
   */
  controlName: string;

  /**
   * 部件代码名称
   */
  controlCodeName: string;

  /**
   * 上下文参数
   */
  context: IParam;

  /**
   * 视图参数
   */
  viewParams: IParam;

  /**
   * 视图参数(外部传入)
   */
  viewSubject: Subject<IActionParam>;

  // 声明任意属性
  [propName: string]: any;
}